/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.export.VWExportWizardDialog;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class VWExportSummaryPanel
extends JPanel
implements IVWWizardPanel {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    private JTextArea m_messageTextArea = null;
    private JScrollPane m_scrollPane = null;
    private Icon m_icon = UIManager.getIcon("OptionPane.informationIcon");
    private String m_message = null;
    private int m_msgType = 2;
    private boolean m_showState = true;
    private VWExportWizardDialog m_parentDialog = null;
    private FocusAdapter m_focusAdapter = null;
    private AdjustmentListener m_adjustmentListener = null;

    public VWExportSummaryPanel(VWExportWizardDialog parentDialog) {
        this.m_parentDialog = parentDialog;
        this.createControls();
    }

    public void init(String msgs, Icon icon) {
        this.m_icon = icon;
        if (msgs != null) {
            this.m_messageTextArea.setText(msgs);
            this.m_messageTextArea.setCaretPosition(0);
            VWAccessibilityHelper.setAccessibility(this.m_messageTextArea, this.m_scrollPane, VWResource.Summary, msgs);
            this.m_messageTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
    }

    private void createControls() {
        try {
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            this.m_messageTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            Color bgColor = this.getBackground();
            this.m_messageTextArea.setBackground(bgColor);
            Font boldFont = null;
            Font normalFont = this.getFont();
            if (normalFont != null) {
                boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
            }
            this.m_messageTextArea.setFont(boldFont);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            if (this.m_icon != null) {
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                JLabel iconLabel = new JLabel(this.m_icon);
                this.add((Component)iconLabel, gbCons);
                ++gbCons.gridx;
            }
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_scrollPane = new JScrollPane(this.m_messageTextArea);
            this.m_scrollPane.setBorder(null);
            this.add((Component)this.m_scrollPane, gbCons);
            this.m_focusAdapter = new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        while (parent != null && !(parent instanceof JScrollPane)) {
                            if (!(parent instanceof JComponent)) continue;
                            parent = ((JComponent)parent).getParent();
                        }
                        if (parent != null && parent instanceof JScrollPane && (parent = ((JScrollPane)parent).getParent()) != null && parent instanceof JPanel) {
                            ((JPanel)parent).setBorder(BorderFactory.createLineBorder(((JPanel)parent).getForeground()));
                        }
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        while (parent != null && !(parent instanceof JScrollPane)) {
                            if (!(parent instanceof JComponent)) continue;
                            parent = ((JComponent)parent).getParent();
                        }
                        if (parent != null && parent instanceof JScrollPane && (parent = ((JScrollPane)parent).getParent()) != null && parent instanceof JPanel) {
                            ((JPanel)parent).setBorder(BorderFactory.createLineBorder(((JPanel)parent).getBackground()));
                        }
                    }
                }
            };
            this.m_messageTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_messageTextArea.addFocusListener(this.m_focusAdapter);
            JScrollBar scrollBar = this.m_scrollPane.getVerticalScrollBar();
            this.m_adjustmentListener = new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (e.getSource() != null && e.getSource() instanceof JScrollBar) {
                        JScrollBar sb = (JScrollBar)e.getSource();
                        boolean bFocusable = sb.getMaximum() != sb.getVisibleAmount();
                        for (Container parent = sb.getParent(); parent != null; parent = parent.getParent()) {
                            if (!(parent instanceof JPanel)) continue;
                            parent.setFocusable(bFocusable);
                            VWExportSummaryPanel.this.m_messageTextArea.setFocusable(bFocusable);
                            break;
                        }
                    }
                }
            };
            scrollBar.addAdjustmentListener(this.m_adjustmentListener);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void checkForErrors() throws Exception {
    }

    public String getTitle() {
        return VWResource.Summary;
    }

    public String getInstructions() {
        return VWResource.ExportSummaryInstruction.toString(this.m_parentDialog.getExportImportFile(), this.m_parentDialog.getManifestFile());
    }

    public String getUniqueIdentifier() {
        return "EXPORT_SUMMARY";
    }

    public String getHelpTopic() {
        return "summary";
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_messageTextArea != null) {
            this.m_messageTextArea.removeAll();
            this.m_messageTextArea = null;
        }
        if (this.m_scrollPane != null) {
            this.m_scrollPane.removeAll();
            this.m_scrollPane = null;
        }
        this.m_icon = null;
        this.m_message = null;
        this.m_adjustmentListener = null;
        this.m_focusAdapter = null;
    }

    public void setDisplayState(boolean bState) {
        this.m_showState = bState;
    }

    public boolean getDisplayState() {
        return this.m_showState;
    }

    public boolean getEnableFinishButton() {
        return true;
    }
}

